/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle;

import com.eeeab.eeeabsmobs.client.render.EERenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleDust
extends TextureSheetParticle {
    private final float scale;
    private final EnumDustBehavior behavior;
    private final float airDiffusionSpeed;

    public ParticleDust(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, double scale, int duration, EnumDustBehavior behavior, double airDiffusionSpeed) {
        super(world, x, y, z);
        this.scale = (float)scale * 0.5f * 0.1f;
        this.f_107225_ = duration;
        this.f_107215_ = vx * 0.5;
        this.f_107216_ = vy * 0.5;
        this.f_107217_ = vz * 0.5;
        this.behavior = behavior;
        this.f_107231_ = this.f_107204_ = (float)((double)this.f_107223_.m_188503_(4) * Math.PI / 2.0);
        this.airDiffusionSpeed = (float)airDiffusionSpeed;
    }

    public ParticleRenderType m_7556_() {
        return EERenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ *= (double)this.airDiffusionSpeed;
        this.f_107216_ *= (double)this.airDiffusionSpeed;
        this.f_107217_ *= (double)this.airDiffusionSpeed;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107230_ = 0.25f * (float)(1.0 - Math.exp(5.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.f_107230_ < 0.01) {
            this.f_107230_ = 0.01f;
        }
        this.f_107663_ = this.behavior == EnumDustBehavior.SHRINK ? this.scale * (1.0f - 0.7f * var + 0.3f) : (this.behavior == EnumDustBehavior.GROW ? this.scale * (0.7f * var + 0.3f) : this.scale);
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public static enum EnumDustBehavior {
        SHRINK,
        GROW,
        CONSTANT;

    }

    public static class DustData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<DustData> DESERIALIZER = new ParticleOptions.Deserializer<DustData>(){

            public DustData fromCommand(ParticleType<DustData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                float airDrag = (float)reader.readDouble();
                return new DustData(particleTypeIn, r, g, b, scale, duration, EnumDustBehavior.CONSTANT, airDrag);
            }

            public DustData fromNetwork(ParticleType<DustData> particleTypeIn, FriendlyByteBuf buffer) {
                return new DustData(particleTypeIn, buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), EnumDustBehavior.CONSTANT, buffer.readFloat());
            }
        };
        private final ParticleType<DustData> type;
        private final float r;
        private final float g;
        private final float b;
        private final float scale;
        private final int duration;
        private final EnumDustBehavior behavior;
        private final float airDiffusionSpeed;

        public DustData(ParticleType<DustData> type, float r, float g, float b, float scale, int duration, EnumDustBehavior behavior, float airDiffusionSpeed) {
            this.type = type;
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
            this.behavior = behavior;
            this.airDiffusionSpeed = airDiffusionSpeed;
            this.duration = duration;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
            buffer.writeFloat(this.airDiffusionSpeed);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d %.2f", Registry.f_122829_.m_7981_(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.duration, Float.valueOf(this.airDiffusionSpeed));
        }

        public ParticleType<DustData> m_6012_() {
            return this.type;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumDustBehavior getBehavior() {
            return this.behavior;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getAirDiffusionSpeed() {
            return this.airDiffusionSpeed;
        }

        public static Codec<DustData> CODEC(ParticleType<DustData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(DustData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(DustData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(DustData::getB), (App)Codec.FLOAT.fieldOf("scale").forGetter(DustData::getScale), (App)Codec.STRING.fieldOf("behavior").forGetter(dustData -> dustData.getBehavior().toString()), (App)Codec.INT.fieldOf("duration").forGetter(DustData::getDuration), (App)Codec.FLOAT.fieldOf("airDiffusionSpeed").forGetter(DustData::getAirDiffusionSpeed)).apply((Applicative)codecBuilder, (r, g, b, scale, behavior, duration, airDiffusionSpeed) -> new DustData(particleType, r.floatValue(), g.floatValue(), b.floatValue(), scale.floatValue(), (int)duration, EnumDustBehavior.valueOf(behavior), airDiffusionSpeed.floatValue())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class DustFactory
    implements ParticleProvider<DustData> {
        private final SpriteSet spriteSet;

        public DustFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(DustData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleDust particleDust = new ParticleDust(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getScale(), typeIn.getDuration(), typeIn.getBehavior(), typeIn.getAirDiffusionSpeed());
            particleDust.m_108339_(this.spriteSet);
            particleDust.m_107253_(typeIn.getR(), typeIn.getG(), typeIn.getB());
            return particleDust;
        }
    }
}

